<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlTypeCamp\Domain\HtlTypeCampRepository;
use App\Modules\HtlTypeCamp\Infrastructure\MysqlHtlTypeCampRepository;

$app->bind(HtlTypeCampRepository::class, fn ($app) => $app->make(MysqlHtlTypeCampRepository::class));

$router->post(
    '/htlTypeCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeCamp\\HtlTypeCampInsertController@__invoke'
    ]
);

$router->put(
    '/htlTypeCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeCamp\\HtlTypeCampUpdateController@__invoke'
    ]
);

$router->get(
    '/htlTypeCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeCamp\\HtlTypeCampIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlTypeCamp/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeCamp\\HtlTypeCampListController@__invoke'
    ]
);

$router->delete(
    '/htlTypeCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeCamp\\HtlTypeCampDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
