<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use Illuminate\Support\Facades\Route;

use App\Modules\HtlCamp\Domain\HtlCampRepository;
use App\Modules\HtlCamp\Infraestructure\MysqlHtlCampRepository;

$app->bind(HtlCampRepository::class, fn ($app) => $app->make(MysqlHtlCampRepository::class));

Route::post(
    '/htlCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlCamp@Insert'
    ]
);

Route::post(
    '/htlCamp/update',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlCamp@Update'
    ]
);

Route::delete(
    '/htlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlCamp@Delete'
    ]
)->where(['Id' => '[0-9]*']);

Route::get(
    '/htlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlCamp@Index'
    ]
)->where(['Id' => '[0-9]*']);

Route::get(
    '/htlCamp/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlCamp@List'
    ]
);
