<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalReviewProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderInsertController@__invoke'
    ]
);

$router->put(
    '/externalReviewProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalReviewProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalReviewProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    'externalReview/{IdExternalReview}/externalReviewProvider/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderListController@__invoke'
    ]
)->where('IdExternalReview', '[0-9]*');
