<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\CalendarTour\Domain\CalendarTourAlterRepository;
use App\Modules\CalendarTour\Infrastructure\MysqlCalendarTourAlterRepository;

$app->bind(CalendarTourAlterRepository::class, fn($app) => $app->make(MysqlCalendarTourAlterRepository::class));

$router->get(
    '/calendarTour/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CalendarTour\\CalendarTourPassengerController@__invoke'
    ]
);
