<?php

namespace App\Providers\User\BookingReport;

use ArrayAccess;
use ArrayIterator;
use Countable;
use IteratorAggregate;
use TypeError;

class UserReportBookingDataCollection implements Countable, ArrayAccess, IteratorAggregate
{

    private array $data;

    public function __construct(
        UserReportBookingData ...$data
    ) {
        $this->data = $data;
    }

    public function data()
    {
        return $this->data;
    }

    public function count(): int
    {
        return count($this->data);
    }

    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->data);
    }

    public function offsetExists($offset): bool
    {
        return isset($this->data[$offset]);
    }

    public function offsetGet($offset): UserReportBookingData
    {
        return $this->data[$offset];
    }

    public function offsetSet($offset, $value): void
    {
        if ($value instanceof UserReportBookingData) {
            $this->data[$offset] = $value;
        } else {
            throw new TypeError("Invalid value type");
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->data[$offset]);
    }
}
