<?php

namespace App\Providers\ExcelReport;

class Utils
{

    public static function print($text)
    {
        return fn ($cell) => array_merge($cell, [['action' => 'print', 'text' => $text]]);
    }

    public static function merge($lines)
    {
        return fn($cell) => array_merge($cell, [['action' => 'merge', 'lines' => $lines]]);
    }

    public static function vmerge($lines)
    {
        return fn($cell) => array_merge($cell, [['action' => 'vmerge', 'lines' => $lines]]);
    }

    public static function cell()
    {
        return [];
    }
    public static function width($width)
    {
        return fn ($cell) => array_merge($cell, [['action' => 'width', 'width' => $width]]);
    }
    public static function wrap($cell)
    {
        return array_merge($cell, [['action' => 'wrap']]);
    }
    public static function rangeValues(array $values, $promptTitle = '', $prompt = '')
    {
        return fn ($cell) => array_merge($cell, [['action' => 'rangeValues', 'elements' => $values, 'promptTitle' => $promptTitle, 'prompt' => $prompt]]);
    }
    public static function color($color)
    {
        return fn ($cell) => array_merge($cell, [['action' => 'color', 'color' => $color]]);
    }
    public static function background($color)
    {
        return fn ($cell) => array_merge($cell, [['action' => 'background', 'color' => $color]]);
    }
    public static function top($cell)
    {
        return array_merge($cell, [['action' => 'top']]);
    }
    public static function border($cell)
    {
        return array_merge($cell, [['action' => 'border']]);
    }
    public static function borderBottom($cell)
    {
        return array_merge($cell, [['action' => 'borderBottom']]);
    }
    public static function bold($cell)
    {
        return array_merge($cell, [['action' => 'bold']]);
    }
    public static function center($cell)
    {
        return array_merge($cell, [['action' => 'center']]);
    }
    public static function left($cell)
    {
        return array_merge($cell, [['action' => 'left']]);
    }
    public static function right($cell)
    {
        return array_merge($cell, [['action' => 'right']]);
    }
    public static function compose(...$functions)
    {
        return function ($value) use ($functions) {
            $length = count($functions);
            $data = null;
            for ($i = $length - 1; $i >= 0; $i--) {
                if ($i == $length - 1) {
                    $data = $functions[$i]($value);
                } else {
                    $data = $functions[$i]($data);
                }
            }
            return $data;
        };
    }
}
