<?php

namespace App\Providers\ExcelGroupReport;

use App\Http\Helpers\DateTime;

class PrintPage extends ExcelPage {

    public function subtitle ($text) { return [[ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }

    public function run ($oGroup, $oData) {
        $res= [
            [],
            [],
            [
                [['action' => 'print', 'text' => $oData->Title], [ 'action' => 'center'], ['action' => 'bold']],
            ],
            [],
            [
                [[ 'action' => 'print', 'text' => 'TOUR:' ], ['action' => 'bold']],
                [[ 'action' => '' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Service_Name]],
                [[ 'action' => 'advance', 'lines' => 4]],
                [[ 'action' => 'print', 'text' => 'NRO. PAX:' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_NoPassenger ]],
            ],
            [
                [[ 'action' => 'print', 'text' => 'FECHA INICIO:' ], ['action' => 'bold']],
                [[ 'action' => '' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_DateStart ]],
                [[ 'action' => 'advance', 'lines' => 4]],
                [[ 'action' => 'print', 'text' => 'FECHA FIN:' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_DateEnd ]],
            ],
            // [
            //     [[ 'action' => 'print', 'text' => 'GUIA:' ], [ 'action' => 'bold' ]],
            //     [[ 'action' => '' ]],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Guide_Main . ' - ' . $oGroup->Group_Guide_Main_Phone ."\n" . $oGroup->Group_Guide_Main_Remark]],
            //     [[ 'action' => 'advance', 'lines' => 4]],
            //     [[ 'action' => 'print', 'text' => 'SEGUNDO GUIA:' ], [ 'action' => 'bold']],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Guide_Second . ' - ' . $oGroup->Group_Guide_Second_Phone."\n" . $oGroup->Group_Guide_Second_Remark ]],
            // ],
            // [
            //     [[ 'action' => 'print', 'text' => 'COCINERO:' ], [ 'action' => 'bold']],
            //     [[ 'action' => '' ]],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Cook . ' - ' . $oGroup->Group_Cook_Phone ."\n" . $oGroup->Group_Cook_Remark]],
            //     [[ 'action' => 'advance', 'lines' => 4]],
            //     [[ 'action' => 'print', 'text' => 'ARRIERO:' ], [ 'action' => 'bold']],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Horseman . ' - ' . $oGroup->Group_Horseman_Phone ."\n" . $oGroup->Group_Horseman_Remark]],
            // ],
            // [
            //     [[ 'action' => 'print', 'text' => 'TRANSPORTE:' ], [ 'action' => 'bold']],
            //     [[ 'action' => '' ]],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Transport . ' - ' . $oGroup->Group_Transport_Phone ."\n" . $oGroup->Group_Transport_Remark]],
            //     [[ 'action' => 'advance', 'lines' => 4]],
            //     [[ 'action' => 'print', 'text' => 'COCINERO:' ], [ 'action' => 'bold']],
            //     [[ 'action' => 'print', 'text' => $oGroup->Group_Restaurant_Remark . ' - ' . $oGroup->Group_Restaurant_Phone."\n" . $oGroup->Group_Restaurant_Remark ]],
            // ],
        ];
        $length=ceil(Count($oGroup->Providers) / 2);
        $res_new=[];
        for($k = 0; $k < $length; $k++){

            $res_new = [
                [[ 'action' => 'print', 'text' =>$oGroup->Providers[$k*2]->NameType ], ['action' => 'bold']],
                [[ 'action' => '' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Providers[$k*2]->Provider ]],
                [[ 'action' => 'advance', 'lines' => 4]],
            ];
            if(($k+1)*2<=Count($oGroup->Providers)){
                $array_new=[
                    [[ 'action' => 'print', 'text' => $oGroup->Providers[$k*2+1]->NameType ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Providers[$k*2+1]->Provider ]], 
                ];
                
            }else{
                $array_new=[
                    [[ 'action' => 'print', 'text' => ""], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => "" ]], 
                ];
            }
            
            $res_new=array_values(array_merge($res_new,$array_new));
            $res_new=[$res_new];
            $res=array_merge($res,$res_new);
        }
        $res_new=[
            [

                [[ 'action' => 'print', 'text' => 'OBSERVACIONES:' ], [ 'action' => 'bold']],
                [[ 'action' => '' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_Remark ]],
            ]
        ];

        $res=array_merge($res,$res_new);
        
        if($oGroup->Group_ServiceType==2){
            $res_new=[
                [
                    [[ 'action' => 'print', 'text' => 'ORIGEN:' ], ['action' => 'bold'],],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_Origin ]],
                    [[ 'action' => 'advance', 'lines' => 4]],
                    [[ 'action' => 'print', 'text' => 'DESTINO' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_Destination]], 
                ],
                [
                    [[ 'action' => 'print', 'text' => 'FECHA DE RECOJO:' ], ['action' => 'bold']],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_DateStart.' '.$oGroup->Group_Hour ]]
                ]
            ];
            $res=array_merge($res,$res_new);
        }
        if($oGroup->Group_ServiceType>2){
            $res_new=[
                [
                    [[ 'action' => 'print', 'text' => 'VUELO:' ], ['action' => 'bold']],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Fligth[4] ]],
                    [[ 'action' => 'advance', 'lines' => 4]],
                    [[ 'action' => 'print', 'text' => 'NUMERO DE VUELO' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Fligth[3] ]], 
                ],
                [
                    [[ 'action' => 'print', 'text' => 'ORIGEN:' ], ['action' => 'bold'],],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Fligth[1] ]],
                    [[ 'action' => 'advance', 'lines' => 4]],
                    [[ 'action' => 'print', 'text' => 'DESTINO' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Fligth[2] ]], 
                ],
                [
                    [[ 'action' => 'print', 'text' => 'FECHA Y HORA DE RECOJO:' ], ['action' => 'bold']],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => DateTime::dateTimeTransformNS($oGroup->Fligth[0]) ]],
                    [[ 'action' => 'advance', 'lines' => 4]],
                    [[ 'action' => 'print', 'text' => 'OBSERVACIONES DE VUELO' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Fligth[5] ]], 
                ],
            ];
            $res=array_merge($res,$res_new);
        }
        return $res;
    }

}