<?php

namespace App\Providers\ExcelCashMovementReport;

use App\Http\Helpers\CashMovementHelper;
use App\Http\Helpers\DateTime;
use App\Providers\ExcelReport\Utils;

class CashMovementCells
{
    private const BACKGROUNDS_PAYMENT = 'FFA95B5B';

    private const BASIC_BACKGROUND = 'FF707070';

    private function title($text, $width, $color)
    {
        $fnPrint = Utils::print($text);
        $fnWidth = Utils::width($width);
        $fnBackground = Utils::background($color);
        $fnColor = Utils::color('FFFFFFFF');
        return Utils::wrap(Utils::top(Utils::border(Utils::bold($fnBackground($fnColor($fnPrint($fnWidth(Utils::cell()))))))));
    }

    private function column($text, $orientation, bool $borderBottom)
    {
        if ($borderBottom) {
            return [['action' => 'wrap'], ['action' => 'borderBottom'], ['action' => 'top'], ['action' => $orientation], ['action' => 'print', 'text' => $text]];
        } else {
            return [['action' => 'wrap'], ['action' => 'top'], ['action' => $orientation], ['action' => 'print', 'text' => $text]];
        }
    }

    private function verticalColumn($show, $text, $vGroup, bool $borderBottom)
    {
        return array_merge(
            ($show
                ? [
                    ['action' => 'vmerge', 'lines' => $vGroup],
                    ['action' => 'print', 'text' => $text],
                    ['action' => 'wrap'],
                    ['action' => 'top']
                ]
                : [['action' => '']]
            ),
            $borderBottom ? [['action' => 'borderBottom']] : []
        );
    }

    private function createRows(array $list)
    {
        return array_reduce(
            $list,
            function ($carry, $cur) {
                return array_merge(
                    $carry,
                    $this->generateCashMovement($cur)
                );
            },
            []
        );
    }

    private function generateCashMovement($cashMovement)
    {
        $array = [];
        foreach ($cashMovement->CashMovementDetail as $index => $cmd) {
            $array[] = $this->generateCashMovementDetail($cashMovement, $cmd, $index, count($cashMovement->CashMovementDetail));
        }
        return $array;
    }

    private function getStatusFrom($status1, $status2, $order)
    {
        foreach ($order as $element) {
            if ($status1 == $element || $status2 == $element) {
                return $element;
            }
        }
    }

    private function groupPackages(array $BookingTourCodes): array
    {
        return array_reduce(
            $BookingTourCodes,
            function ($carry, $bt) {
                if (!isset($carry[$bt->BookingTour_Group])) {
                    $carry[$bt->BookingTour_Group] = (object)[
                        'Element' => $bt,
                        'Tours' => [$bt]
                    ];
                } else {
                    $carry[$bt->BookingTour_Group]->ElementBookingTourPassenger_Status = $this->getStatusFrom(
                        $carry[$bt->BookingTour_Group]->Element->BookingTourPassenger_Status,
                        $bt->BookingTourPassenger_Status,
                        [2, 3, 0, 1]
                    );
                    $carry[$bt->BookingTour_Group]->Tours[] = $bt;
                }
                return $carry;
            },
            []
        );
    }

    private function concatPackages(array $packages): string
    {
        $specifyData = ['NO VIAJO', 'ANULADO', 'ACTIVO', 'DIO ALCANCE'];

        return implode("\n", array_map(function ($t) use ($specifyData) {
            $specify = $specifyData[$t->Element->BookingTourPassenger_Status] ?? '';
            return $t->Element->BookingTour_Name
                . ' - '
                . $specify
                . ' (' . date('d-m-Y', strtotime($t->Element->BookingTour_DateStart)) . ')';
        }, $packages));
    }

    private function concatTours(array $packages): string
    {
        $specifyData = ['NO VIAJO', 'ANULADO', 'ACTIVO', 'DIO ALCANCE'];

        return implode("\n", array_map(function ($pack) use ($specifyData) {
            return implode(
                "\n",
                array_map(
                    fn ($t) => $t->BookingTour_TourName
                        . ' - '
                        . ($specifyData[$t->BookingTourPassenger_Status] ?? '')
                        . ' (' . date('d-m-Y', strtotime($t->BookingTour_DateStart)) . ')',
                    $pack->Tours
                )
            );
        }, $packages));
    }

    private function generateCashMovementDetail($cashMovement, $cmd, $index, $count)
    {

        $packages = $this->groupPackages($cmd->Booking_Tour);
        return [
            // $this->verticalColumn($cmd->cant > 0, $cmd->Booking_Code, $cmd->cant - 1, $index == $count - 1),
            $this->column($cmd->Booking_Code, 'left', $index == $count - 1),
            $this->column(DateTime::dateTransform($cashMovement->CashMovement_DatePayment), 'left', $index == $count - 1),
            $this->column($cashMovement->TypePayment_Name, 'left', $index == $count - 1),
            $this->column(CashMovementHelper::changeReceiptNumber($cashMovement), 'left', $index == $count - 1),
            $this->column($cmd->CashMovementDetail_Amount, 'right', $index == $count - 1),
            $this->column($cmd->invoice['TotalPending'], 'right', $index == $count - 1),
            $this->column(($cashMovement->CashMovement_Type == 1 ? '-' : '') . $cashMovement->CashMovement_Amount, 'right', $index == $count - 1),
            $this->column($cashMovement->CashMovement_Remark, 'left', $index == $count - 1),

            $this->column($cmd->Passenger_Name . ' ' . $cmd->Passenger_LastName, 'left', $index == $count - 1),
            $this->column($cmd->Passenger_Gender == 1 ? 'M' : 'F', 'center', $index == $count - 1),
            $this->column($cmd->TypeDocument_Name, 'left', $index == $count - 1),
            $this->column($cmd->Passenger_NoDocument, 'left', $index == $count - 1),
            $this->column($this->concatPackages($packages), 'left', $index == $count - 1),
            $this->column($this->concatTours($packages), 'left', $index == $count - 1),
            $this->column(DateTime::dateTransform($cmd->Booking_DateStart), 'left', $index == $count - 1),

            $this->column($cashMovement->User_Type == 1 ? $cashMovement->User_Name . ' ' . $cashMovement->User_LastName : $cashMovement->User_Name, 'left', $index == $count - 1),
            $this->column($cashMovement->User_Email, 'left', $index == $count - 1),
            $this->column($cashMovement->User_Type == 1 ? 'Regular' : 'Endosador', 'left', $index == $count - 1),
            $this->column($cashMovement->Admin_Name . ' ' . $cashMovement->Admin_LastName, 'left', $index == $count - 1),
        ];
    }
    public function run($oCash, $oMetadata)
    {
        return array_merge(
            [
                [
                    $this->title('RESERVA', 14, self::BASIC_BACKGROUND),
                    $this->title('FECHA DE PAGO', 14, self::BACKGROUNDS_PAYMENT),
                    $this->title('TIPO DE PAGO', 18, self::BACKGROUNDS_PAYMENT),
                    $this->title('NÚMERO DE OPERACIÓN', 20, self::BACKGROUNDS_PAYMENT),
                    $this->title('MONTO PAGADO (PREPAGO) P1', 17, self::BACKGROUNDS_PAYMENT),
                    $this->title('MONTO PENDIENTE', 14, self::BACKGROUNDS_PAYMENT),
                    $this->title('MONTO TOTAL', 14, self::BACKGROUNDS_PAYMENT),
                    $this->title('OBSERVACIONES', 30, self::BACKGROUNDS_PAYMENT),

                    $this->title('NOMBRE COMPLETO', 20, self::BASIC_BACKGROUND),
                    $this->title('S', 5, self::BASIC_BACKGROUND),
                    $this->title('TIPO DOC.', 14, self::BASIC_BACKGROUND),
                    $this->title('DOCUMENTO', 14, self::BASIC_BACKGROUND),
                    $this->title('PACKAGES', 50, self::BASIC_BACKGROUND),
                    $this->title('TOURS', 50, self::BASIC_BACKGROUND),
                    $this->title('F. SALIDA', 15, self::BASIC_BACKGROUND),

                    $this->title('CLIENTE', 18, self::BASIC_BACKGROUND),
                    $this->title('EMAIL', 21, self::BASIC_BACKGROUND),
                    $this->title('TIPO', 14, self::BASIC_BACKGROUND),
                    $this->title('VENDEDOR', 18, self::BASIC_BACKGROUND),
                ],
            ],
            $this->createRows($oCash)
        );
    }
}
