<?php

namespace App\Providers\BookingReport\Confirm\Excel;

use ArrayAccess;
use ArrayIterator;
use Countable;
use IteratorAggregate;
use TypeError;

class ReportBookingDataCollection implements Countable, ArrayAccess, IteratorAggregate
{

    private array $data;

    public function __construct(
        public $typePayment,
        ReportBookingData ...$data
    ) {
        $this->data = $data;
    }

    public function data()
    {
        return $this->data;
    }

    public function count(): int
    {
        return count($this->data);
    }

    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->data);
    }

    public function offsetExists($offset): bool
    {
        return isset($this->data[$offset]);
    }

    public function offsetGet($offset): ReportBookingData
    {
        return $this->data[$offset];
    }

    public function offsetSet($offset, $value): void
    {
        if ($value instanceof ReportBookingData) {
            $this->data[$offset] = $value;
        } else {
            throw new TypeError("Invalid value type");
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->data[$offset]);
    }
}
