<?php

namespace App\Providers\BookingReport\Confirm\Excel;

class ReportBookingData
{
    public float $Payment_Total;
    public function __construct(
        public string $Booking_Code,
        public string $Booking_Date,
        public string $Booking_Type,
        public string $Contact_Name,
        public string | null $Admin_Name,
        public string | null $Admin_LastName,
        public string $User_Email,
        public array $BookingTourCodes,
        public string $Package_Name,
        public string $Package_Code,
        public int $Package_Duration,
        public string $Booking_DateStart,
        public string $Passenger_FullName,
        public string $Passenger_NoDocument,
        public string $Passenger_CheckedInStatus,
        public string $Passenger_Status,
        public string $Passenger_Gender,
        public string $UserCountry_Name,
        public string $BookingTourPassenger_Status,
        public string $CashMovement_Total,
        public bool $LastPassenger,
        public bool $FirstPassenger,
        public PaymentDataCollection $payments
    ) {
        $total = 0;
        foreach ($payments->data() as $payment) {
            $total += $payment->CashMovement_Amount;
        }
        $this->Payment_Total = $total;
    }
}
