<?php

namespace App\Modules\WebContactMessage\Domain;

use App\Modules\WebContact\Domain\IdWebContact;

/**
 * Status in the group for filtering and display
 */
class UpdateWebContactMessage
{

    public function __construct(
        private WebContactMessageMessage $message,
        private WebContactMessageAdults $adults,
        private WebContactMessageChildren $children,
        private WebContactMessageSubscription $subscription,
        private WebContactMessageStatus $status,
        private IdWebContact $idWebContact,
        private ?IdWebContactMessage $id = null,
    ) {
    }

    public function id(): IdWebContactMessage
    {
        return $this->id;
    }

    public function message(): WebContactMessageMessage
    {
        return $this->message;
    }

    public function adults(): WebContactMessageAdults
    {
        return $this->adults;
    }

    public function children(): WebContactMessageChildren
    {
        return $this->children;
    }

    public function subscription(): WebContactMessageSubscription
    {
        return $this->subscription;
    }

    public function status(): WebContactMessageStatus
    {
        return $this->status;
    }

    public function idWebContact(): IdWebContact
    {
        return $this->idWebContact;
    }
}
