<?php

namespace App\Modules\WebContactMessage\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Application\List\ListWebContactMessageQueryResponse;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageLister
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(IdWebContact $idWebContact, string $action): ListWebContactMessageQueryResponse
    {
        return new ListWebContactMessageQueryResponse($this->repository->find($idWebContact, $action));
    }
}
