<?php

namespace App\Modules\WebContactMessage\Application\Index;

use App\Modules\WebContactMessage\Application\Index\IndexWebContactMessageQueryResponse;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageIndexer
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(IdWebContactMessage $idWebContactMessage): IndexWebContactMessageQueryResponse
    {
        return new IndexWebContactMessageQueryResponse($this->repository->index($idWebContactMessage));
    }
}
