<?php

namespace App\Modules\WebContactMessage\Application\Delete;

use App\Modules\WebContactMessage\Application\Delete\WebContactMessageDeleterResponse;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageDeleter
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(IdWebContactMessage $idWebContactMessage): DeleteWebContactMessageQueryResponse
    {
        return new DeleteWebContactMessageQueryResponse($this->repository->delete($idWebContactMessage));
    }
}
