<?php

namespace App\Modules\WebContactMessage\Application\Create;

use App\Modules\Country\Domain\IdCountry;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\WebContactMessage\Domain\WebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\WebContactMessageAdults;
use App\Modules\WebContactMessage\Domain\WebContactMessageChildren;
use App\Modules\WebContactMessage\Domain\WebContactMessageCountry;
use App\Modules\WebContactMessage\Domain\WebContactMessageCountryCurrent;
use App\Modules\WebContactMessage\Domain\WebContactMessageDateDeparture;
use App\Modules\WebContactMessage\Domain\WebContactMessageDateReception;
use App\Modules\WebContactMessage\Domain\WebContactMessageDateSend;
use App\Modules\WebContactMessage\Domain\WebContactMessageEmail;
use App\Modules\WebContactMessage\Domain\WebContactMessageLastName;
use App\Modules\WebContactMessage\Domain\WebContactMessageMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageName;
use App\Modules\WebContactMessage\Domain\WebContactMessageOrigin;
use App\Modules\WebContactMessage\Domain\WebContactMessagePhone;
use App\Modules\WebContactMessage\Domain\WebContactMessagePhoneCode;
use App\Modules\WebContactMessage\Domain\WebContactMessageSubscription;
use App\Modules\WebContactMessage\Domain\WebContactMessageType;

final class CreateWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageCreator $inserter)
    {
    }

    public function __invoke(CreateWebContactMessageQuery $query): CreateWebContactMessageResponse
    {
        $model = new WebContactMessage(
            new WebContactMessageDateDeparture($query->dateDeparture()),
            new WebContactMessageDateSend($query->dateSend()),
            new WebContactMessageDateReception($query->dateReception()),
            new WebContactMessageName($query->name()),
            new WebContactMessageLastName($query->lastName()),
            new WebContactMessageEmail($query->email()),
            new WebContactMessageCountry($query->country()),
            new WebContactMessageCountryCurrent($query->countryCurrent()),
            new WebContactMessagePhoneCode($query->phoneCode()),
            new WebContactMessagePhone($query->phone()),
            new IdCountry($query->idCountry()),
            new IdCountry($query->idCountryCurrent()),
            new WebContactMessageMessage($query->message()),
            new WebContactMessageAdults($query->adults()),
            new WebContactMessageChildren($query->children()),
            new WebContactMessageSubscription($query->subscription()),
            new WebContactMessageOrigin($query->origin()),
            new WebContactMessageType($query->type()),
            new WebContactMessageStatus($query->status()),
            new IdWebContact($query->idWebContact()),
            new IdLanguage($query->idLanguage()),
        );
        return $this->inserter->__invoke($model);
    }
}
