<?php

namespace App\Modules\WebContactMessage\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateWebContactMessageQuery implements Query
{
    public function __construct(
        private string $dateDeparture,
        private string $dateSend,
        private string $dateReception,
        private string $name,
        private string $lastName,
        private string $email,
        private string $country,
        private string $countryCurrent,
        private string $phoneCode,
        private string $phone,
        private int $idCountry,
        private int $idCountryCurrent,
        private string $message,
        private int $adults,
        private int $children,
        private int $subscription,
        private string $origin,
        private int $type,
        private int $status,
        private int $idWebContact,
        private int $idLanguage
    ) {
    }

    public function dateDeparture(): string
    {
        return $this->dateDeparture;
    }

    public function dateSend(): string
    {
        return $this->dateSend;
    }

    public function dateReception(): string
    {
        return $this->dateReception;
    }

    public function name(): string
    {
        return $this->name;
    }

    public function lastName(): string
    {
        return $this->lastName;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function country(): string
    {
        return $this->country;
    }

    public function countryCurrent(): string
    {
        return $this->countryCurrent;
    }

    public function phoneCode(): string
    {
        return $this->phoneCode;
    }

    public function phone(): string
    {
        return $this->phone;
    }

    public function idCountry(): int
    {
        return $this->idCountry;
    }

    public function idCountryCurrent(): int
    {
        return $this->idCountryCurrent;
    }


    public function message(): string
    {
        return $this->message;
    }

    public function adults(): int
    {
        return $this->adults;
    }

    public function children(): int
    {
        return $this->children;
    }

    public function subscription(): int
    {
        return $this->subscription;
    }

    public function origin(): string
    {
        return $this->origin;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idWebContact(): int
    {
        return $this->idWebContact;
    }

    public function idLanguage(): int
    {
        return $this->idLanguage;
    }
}
