<?php

namespace App\Modules\WebContact\Application\Update;

use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactName;
use App\Modules\WebContact\Domain\WebContactStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\UpdateWebContact;
use App\Modules\WebContact\Domain\WebContactCountry;
use App\Modules\WebContact\Domain\WebContactEmail;
use App\Modules\WebContact\Domain\WebContactLastName;
use App\Modules\WebContact\Domain\WebContactPhone;
use App\Modules\WebContact\Domain\WebContactPhoneCode;

final class UpdateWebContactQueryHandler implements QueryHandler
{
    public function __construct(private WebContactUpdater $updater)
    {
    }

    public function __invoke(UpdateWebContactQuery $query): UpdateWebContactQueryResponse
    {
        $model = new UpdateWebContact(
            new WebContactName($query->name()),
            new WebContactLastName($query->lastName()),
            new WebContactEmail($query->email()),
            new WebContactPhoneCode($query->phoneCode()),
            new WebContactPhone($query->phone()),
            new WebContactStatus($query->status()),
            new IdWebContact($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
