<?php

namespace App\Modules\UserCountry\Domain;

class UserCountry {

    private UserCountryName $name;
    private UserCountryCode $code;
    private UserCountryPhoneCode $phoneCode;
    private UserCountryImg $img;
    private UserCountryFrequent $frequent;
    private UserCountryFrequentOrder $frequentOrder;
    private UserCountryStatus $status;
    private ?IdUserCountry $id;

    /** constructor */
    public function __construct (
        UserCountryName $name,
        UserCountryCode $code,
        UserCountryPhoneCode $phoneCode,
        UserCountryImg $img,
        UserCountryFrequent $frequent,
        UserCountryFrequentOrder $frequentOrder,
        UserCountryStatus $status,
        ?IdUserCountry $id = NULL
    ) {
        $this->name = $name;
        $this->code = $code;
        $this->phoneCode = $phoneCode;
        $this->img = $img;
        $this->frequent = $frequent;
        $this->frequentOrder = $frequentOrder;
        $this->status = $status;
        $this->id = $id;
    }


    public function getName():UserCountryName { return $this->name; }
    public function getCode():UserCountryCode { return $this->code; }
    public function getPhoneCode():UserCountryPhoneCode { return $this->phoneCode; }
    public function getImg():UserCountryImg { return $this->img; }
    public function getFrequent():UserCountryFrequent { return $this->frequent; }
    public function getFrequentOrder():UserCountryFrequentOrder { return $this->frequentOrder; }
    public function getStatus():UserCountryStatus { return $this->status; }
    public function getId():IdUserCountry { return $this->id; }
}