<?php

namespace App\Modules\TypeBookingAssign\Application\Delete;

use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteTypeBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private TypeBookingAssignDeleter $inserter)
    {
    }

    public function __invoke(DeleteTypeBookingAssignQuery $query): DeleteTypeBookingAssignQueryResponse
    {
        return $this->inserter->__invoke(new IdTypeBookingAssign($query->getId()));
    }
}
