<?php

namespace App\Modules\StatusGroupProvider\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\StatusGroupProvider\Application\List\ListStatusGroupProviderQueryResponse;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;

final class StatusGroupProviderLister
{
    public function __construct(private StatusGroupProviderRepository $repository)
    {
    }

    public function __invoke(string $action): ListStatusGroupProviderQueryResponse
    {
        return new ListStatusGroupProviderQueryResponse($this->repository->find($action));
    }
}
