<?php

namespace App\Modules\StatusGroupProvider\Application\Delete;

use App\Modules\StatusGroupProvider\Application\Delete\StatusGroupProviderDeleterResponse;
use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;

final class StatusGroupProviderDeleter
{
    public function __construct(private StatusGroupProviderRepository $repository)
    {
    }

    public function __invoke(IdStatusGroupProvider $idStatusGroupProvider): DeleteStatusGroupProviderQueryResponse
    {
        return new DeleteStatusGroupProviderQueryResponse($this->repository->delete($idStatusGroupProvider));
    }
}
