<?php

namespace App\Modules\StatusGroupProvider\Application\Create;

use App\Modules\StatusGroupProvider\Application\Create\CreateStatusGroupProviderResponse;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;

final class StatusGroupProviderCreator
{
    public function __construct(private StatusGroupProviderRepository $repository)
    {
    }

    public function __invoke(StatusGroupProvider $model): CreateStatusGroupProviderResponse
    {
        return new CreateStatusGroupProviderResponse($this->repository->insert($model));
    }
}
