<?php

namespace App\Modules\StatusGroup\Application\Update;

use App\Modules\StatusGroup\Application\Update\UpdateStatusGroupQueryResponse;
use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;

final class StatusGroupUpdater
{
    public function __construct(private StatusGroupRepository $repository)
    {
    }

    public function __invoke(StatusGroup $statusGroup): UpdateStatusGroupQueryResponse
    {
        return new UpdateStatusGroupQueryResponse($this->repository->update($statusGroup));
    }
}
