<?php

namespace App\Modules\StatusGroup\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\StatusGroup\Application\List\ListStatusGroupQueryResponse;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;

final class StatusGroupLister
{
    public function __construct(private StatusGroupRepository $repository)
    {
    }

    public function __invoke(string $action): ListStatusGroupQueryResponse
    {
        return new ListStatusGroupQueryResponse($this->repository->find($action));
    }
}
