<?php

namespace App\Modules\StatusGroup\Application\Delete;

use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteStatusGroupQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupDeleter $inserter)
    {
    }

    public function __invoke(DeleteStatusGroupQuery $query): DeleteStatusGroupQueryResponse
    {
        return $this->inserter->__invoke(new IdStatusGroup($query->getId()));
    }
}
