<?php

namespace App\Modules\StatusGroup\Application\Create;

use App\Modules\StatusGroup\Application\Create\CreateStatusGroupResponse;
use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;

final class StatusGroupCreator
{
    public function __construct(private StatusGroupRepository $repository)
    {
    }

    public function __invoke(StatusGroup $statusGroup): CreateStatusGroupResponse
    {
        return new CreateStatusGroupResponse($this->repository->insert($statusGroup));
    }
}
