<?php

namespace App\Modules\Shared\Validator\Domain;

class ValidationCode
{

    public function __construct(
        private string $key,
        private array $rules = []
    ) {
    }

    public function getKey()
    {
        if (!count($this->rules)) {
            return null;
        }
        return $this->key;
    }

    public function getRules()
    {
        return implode('|', array_map(fn ($rule) => $rule->getRule(), $this->rules));
    }
}
