<?php

namespace App\Modules\Shared\Infraestructure\Command;

use App\Modules\Shared\Domain\Bus\Command\Command;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use Illuminate\Bus\Dispatcher;

final class IlluminateCommandBus implements CommandBus
{

    public function __construct(
        protected Dispatcher $bus
    ) {}

    public function dispatch(Command $command)
    {
        $this->bus->dispatch($command);
    }

    public function register(array $map): void
    {
        $this->bus->map($map);
    }
}
