<?php

namespace App\Modules\ReviewSession\Infraestructure;

use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\ReviewSession\Domain\ReviewSessionRepository;
use App\Modules\ReviewSession\Domain\IdReviewSession;
use App\Modules\ReviewSession\Domain\ReviewSessionToken;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlReviewSessionRepository implements ReviewSessionRepository
{

    public function findToken(ReviewSessionToken $token)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_session_find_token(?,@sts,@cod,@msg)',
            [
                $token->value()
            ]
        );
    }

    public function find(string $query, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_session_list(?,?,?,@sts,@cod,@msg)',
            [
                $query,
                $action
            ]
        );
    }

    public function index(IdReviewSession $id)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_session_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(PassengerNoDocument $noDocument)
    {
        return Requester::requestInsert(
            'CALL sp_passenger_review_session_insert(?,@sts,@cod,@msg,@id)',
            [
                $noDocument->getValue()
            ]
        );
    }

    public function update(IdReviewSession $id)
    {
        return Requester::requestUpdate(
            'CALL sp_passenger_review_session_update(?@sts,@cod,@msg)',
            [
                $id->value()
            ]
        );
    }

    public function delete(IdReviewSession $id)
    {
        return Requester::requestUpdate(
            'CALL sp_passenger_review_session_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
