<?php

namespace App\Modules\ReviewSession\Application\Create;

use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\ReviewSession\Domain\ReviewSessionRepository;

final class ReviewSessionCreator
{
    public function __construct(
        private ReviewSessionRepository $repository
    ) {
    }

    public function create(PassengerNoDocument $passengerNoDocument)
    {
        return $this->repository->insert($passengerNoDocument);
    }
}
