<?php

namespace App\Modules\ReviewNotification\Application\Reply;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\InsertReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationDescription;
use App\Modules\ReviewNotification\Domain\ReviewNotificationStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReplyReviewNotificationQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationReplier $replier)
    {
    }

    public function __invoke(ReplyReviewNotificationQuery $query): ReplyReviewNotificationResponse
    {
        $model = new InsertReviewNotification(
            new ReviewNotificationDescription($query->getDescription()),
            new ReviewNotificationStatus(ReviewNotificationStatus::RESOLVED),
            new IdGroupPassenger($query->getIdGroupPassenger()),
            new IdAdmin($query->getIdAdminCreate()),
            new IdReviewNotification($query->getIdReviewNotificationParent())
        );
        return $this->replier->__invoke($model);
    }
}
