<?php

namespace App\Modules\ReviewNotification\Application\Index;

use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationIndexerQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationIndexer $indexer)
    {
    }

    public function __invoke(ReviewNotificationIndexerQuery $query): ReviewNotificationIndexerResponse
    {
        return $this->indexer->__invoke(new IdReviewNotification($query->getId()));
    }
}
