<?php

namespace App\Modules\ReviewNotification\Application\Delete;

use App\Modules\ReviewNotification\Application\Delete\ReviewNotificationDeleterResponse;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationDeleter
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(IdReviewNotification $idReviewNotification): ReviewNotificationDeleterResponse
    {
        return new ReviewNotificationDeleterResponse($this->repository->delete($idReviewNotification));
    }
}
