<?php
namespace App\Modules\ReviewDetail\Application\Find;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewDetail\Application\ReviewDetailsResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewDetailFindQueryHandler implements QueryHandler
{
    public function __construct(
        private ReviewDetailFinder $finder
    ) {
    }

    public function __invoke(ReviewDetailFindQuery $query): ReviewDetailsResponse
    {
        return $this->finder->__invoke(new IdGroupPassenger($query->idGroupPassenger()));
    }
}
