<?php

namespace App\Modules\Report\Booking\Application\BySellerMonthly;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class ReportBySellerMonthlyBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private BySellerMonthlyBookingReporter $reporter
    ) {
    }

    public function __invoke(ReportBySellerMonthlyBookingQuery $query): ReportBySellerMonthlyBookingResponse
    {
        return new ReportBySellerMonthlyBookingResponse(
            $this->reporter->__invoke(
                new DateStart($query->dateStart()),
                new DateEnd($query->dateEnd())
            )
        );
    }
}
