<?php

namespace App\Modules\Report\Booking\Application\BySellerMonthly;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReportBySellerMonthlyBookingQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
}
