<?php

namespace App\Modules\QuestionTypeProvider\Application\Update;

use App\Modules\QuestionTypeProvider\Application\Update\QuestionTypeProviderUpdaterResponse;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;

final class QuestionTypeProviderUpdater
{
    public function __construct(private QuestionTypeProviderRepository $repository)
    {
    }

    public function __invoke(QuestionTypeProvider $QuestionTypeProvider): QuestionTypeProviderUpdaterResponse
    {
        return new QuestionTypeProviderUpdaterResponse($this->repository->update($QuestionTypeProvider));
    }
}
