<?php

namespace App\Modules\QuestionTypeProvider\Application\Create;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderForPassenger;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderShow;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

final class QuestionTypeProviderInserterQueryHandler implements QueryHandler
{
    public function __construct(private QuestionTypeProviderInserter $inserter)
    {
    }

    public function __invoke(QuestionTypeProviderInserterQuery $query): QuestionTypeProviderInserterResponse
    {
        $model = new QuestionTypeProvider(
            new QuestionTypeProviderShow($query->show()),
            new QuestionTypeProviderForPassenger($query->forPassenger()),
            new QuestionTypeProviderStatus($query->status()),
            new IdProvider($query->idProvider()),
            new IdTypeProvider($query->idTypeProvider()),
        );
        return $this->inserter->__invoke($model);
    }
}
