<?php

namespace App\Modules\QuestionTypeProvider\Application\Create;

use App\Modules\QuestionTypeProvider\Application\Create\QuestionTypeProviderInserterResponse;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;

final class QuestionTypeProviderInserter
{
    public function __construct(private QuestionTypeProviderRepository $repository)
    {
    }

    public function __invoke(QuestionTypeProvider $QuestionTypeProvider): QuestionTypeProviderInserterResponse
    {
        return new QuestionTypeProviderInserterResponse($this->repository->insert($QuestionTypeProvider));
    }
}
