<?php

namespace App\Modules\ProviderTypeProvider\Application\Delete;

use App\Modules\ProviderTypeProvider\Application\Delete\ProviderTypeProviderDeleterResponse;
use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;

final class ProviderTypeProviderDeleter
{
    public function __construct(private ProviderTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdProviderTypeProvider $idProviderTypeProvider): ProviderTypeProviderDeleterResponse
    {
        return new ProviderTypeProviderDeleterResponse($this->repository->delete($idProviderTypeProvider));
    }
}
