<?php

namespace App\Modules\ProviderTypeProvider\Application\Create;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

final class ProviderTypeProviderInserterQueryHandler implements QueryHandler
{
    public function __construct(private ProviderTypeProviderInserter $inserter)
    {
    }

    public function __invoke(ProviderTypeProviderInserterQuery $query): ProviderTypeProviderInserterResponse
    {
        $model = new ProviderTypeProvider(
            new ProviderTypeProviderStatus($query->status()),
            new IdProvider($query->idProvider()),
            new IdTypeProvider($query->idTypeProvider()),
        );
        return $this->inserter->__invoke($model);
    }
}
