<?php

namespace App\Modules\ProviderSanction\Infraestructure;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRepository;
use App\Modules\ProviderSanction\Domain\IdProviderSanction;
use App\Modules\ProviderSanction\Domain\InsertProviderSanction;
use App\Modules\ProviderSanction\Domain\UpdateProviderSanction;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlProviderSanctionRepository implements ProviderSanctionRepository
{

    public function find(IdProvider $idProvider, string $action, DateTimeStart $dateStart, DateTimeEnd $dateEnd)
    {
        return Requester::requestSelect(
            'CALL sp_provider_sanction_list(?,?,?,?,@sts,@cod,@msg)',
            [
                $idProvider->value(),
                $action,
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
    }

    public function index(IdProviderSanction $id)
    {
        return Requester::requestSelect(
            'CALL sp_provider_sanction_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertProviderSanction $value)
    {
        return Requester::requestInsert(
            'CALL sp_provider_sanction_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->remark()->value(),
                $value->dateStart()->value(),
                $value->dateEnd()->value(),
                $value->status()->value(),
                $value->idProvider()->value(),
            ]
        );
    }

    public function update(UpdateProviderSanction $value)
    {
        return Requester::requestUpdate(
            'CALL sp_provider_sanction_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->remark()->value(),
                $value->dateStart()->value(),
                $value->dateEnd()->value(),
                $value->status()->value(),
                $value->idProvider()->value(),
            ]
        );
    }

    public function delete(IdProviderSanction $id)
    {
        return Requester::requestUpdate(
            'CALL sp_provider_sanction_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
