<?php

namespace App\Modules\ProviderSanction\Domain;

use App\Modules\Provider\Domain\IdProvider;

class ProviderSanction
{

    /** constructor */
    public function __construct(
        private ProviderSanctionDate $date,
        private ProviderSanctionDateUpdate $dateUpdate,
        private ProviderSanctionRemark $remark,
        private ProviderSanctionDateStart $dateStart,
        private ProviderSanctionDateEnd $dateEnd,
        private ProviderSanctionStatus $status,
        private IdProvider $idProvider,
        private ?IdProviderSanction $id = null
    ) {
    }
    public function date(): ProviderSanctionDate
    {
        return $this->date;
    }
    public function dateUpdate(): ProviderSanctionDateUpdate
    {
        return $this->dateUpdate;
    }
    public function remark(): ProviderSanctionRemark
    {
        return $this->remark;
    }
    public function dateStart(): ProviderSanctionDateStart
    {
        return $this->dateStart;
    }
    public function dateEnd(): ProviderSanctionDateEnd
    {
        return $this->dateEnd;
    }
    public function status(): ProviderSanctionStatus
    {
        return $this->status;
    }
    public function idProvider(): IdProvider
    {
        return $this->idProvider;
    }
    public function id(): IdProviderSanction
    {
        return $this->id;
    }
}
