<?php

namespace App\Modules\ProviderSanction\Application\List;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class ProviderSanctionListerQueryHandler implements QueryHandler
{
    public function __construct(private ProviderSanctionLister $inserter)
    {
    }

    public function __invoke(ProviderSanctionListerQuery $query): ProviderSanctionListerResponse
    {
        return $this->inserter->__invoke(
            new IdProvider($query->idProvider()),
            $query->action(),
            new DateTimeStart($query->dateStart()),
            new DateTimeEnd($query->dateEnd())
        );
    }
}
