<?php

namespace App\Modules\ProviderSanction\Application\Delete;

use App\Modules\ProviderSanction\Application\Delete\ProviderSanctionDeleterResponse;
use App\Modules\ProviderSanction\Domain\IdProviderSanction;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRepository;

final class ProviderSanctionDeleter
{
    public function __construct(private ProviderSanctionRepository $repository)
    {
    }

    public function __invoke(IdProviderSanction $idProviderSanction): ProviderSanctionDeleterResponse
    {
        return new ProviderSanctionDeleterResponse($this->repository->delete($idProviderSanction));
    }
}
