<?php

namespace App\Modules\PassengerReview\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\PassengerReview\Domain\PassengerReviewRepository;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPassengerReviewRepository implements PassengerReviewRepository
{
    public function passengerFindByGroup(IdGroup $idGroup, PassengerNoDocument $passengerNoDocument)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_passenger_review_find_by_group(?,?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
                $passengerNoDocument->getValue(),
            ]
        );
    }
    public function passengerFindByGroupPassenger(IdGroupPassenger $idGroupPassenger)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_passenger_review_find_by_group_passenger(?,@sts,@cod,@msg)',
            [
                $idGroupPassenger->value()
            ]
        );
    }
}
