<?php

namespace App\Modules\Passenger\Domain;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeRate\Domain\IdTypeRate;
use App\Modules\UserCountry\Domain\IdUserCountry;

class Passenger
{
    public function __construct(
        private PassengerName $name,
        private PassengerLastName $lastName,
        private PassengerEmail $email,
        private PassengerPhoneCode $phoneCode,
        private PassengerPhone $phone,
        private PassengerGender $gender,
        private PassengerDOB $dob,
        private PassengerNoDocument $noDocument,
        private PassengerRestriction $restriction,
        private PassengerExtras $extras,
        private PassengerReportable $reportable,
        private PassengerStatus $status,
        private IdBooking $idBooking,
        private IdTypeDocument $idTypeDocument,
        private IdTypeRate $idTypeRate,
        private IdUserCountry $idUserCountry,
    ) {
    }

    public function name(): PassengerName
    {
        return $this->name;
    }
    public function lastName(): PassengerLastName
    {
        return $this->lastName;
    }
    public function email(): PassengerEmail
    {
        return $this->email;
    }
    public function phoneCode(): PassengerPhoneCode
    {
        return $this->phoneCode;
    }
    public function phone(): PassengerPhone
    {
        return $this->phone;
    }
    public function gender(): PassengerGender
    {
        return $this->gender;
    }
    public function dob(): PassengerDOB
    {
        return $this->dob;
    }
    public function noDocument(): PassengerNoDocument
    {
        return $this->noDocument;
    }
    public function restriction(): PassengerRestriction
    {
        return $this->restriction;
    }
    public function extras(): PassengerExtras
    {
        return $this->extras;
    }
    public function reportable(): PassengerReportable
    {
        return $this->reportable;
    }
    public function status(): PassengerStatus
    {
        return $this->status;
    }
    public function idBooking(): IdBooking
    {
        return $this->idBooking;
    }
    public function idTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }
    public function idTypeRate(): IdTypeRate
    {
        return $this->idTypeRate;
    }
    public function idUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
}
