<?php

namespace App\Modules\Passenger\Application\UpdateReportable;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerReportable;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdatePassengerReportableQueryHandler implements QueryHandler
{
    public function __construct(
        private PassengerReportableUpdater $reportableUpdater
    ) {
    }

    public function __invoke(UpdatePassengerReportableQuery $query): UpdatePassengerReportableResponse
    {
        return $this->reportableUpdater->__invoke(
            new IdPassenger($query->id()),
            new PassengerReportable($query->reportable())
        );
    }
}
