<?php

namespace App\Modules\Passenger\Application\Deny;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DenyPassengerQueryHandler implements QueryHandler
{
    public function __construct(private PassengerDenier $enabler)
    {
    }

    public function __invoke(DenyPassengerQuery $query): DenyPassengerResponse
    {
        return $this->enabler->__invoke(new IdPassenger($query->id()));
    }
}
