<?php

namespace App\Modules\Passenger\Application\Create;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Passenger\Domain\Passenger;
use App\Modules\Passenger\Domain\PassengerDOB;
use App\Modules\Passenger\Domain\PassengerEmail;
use App\Modules\Passenger\Domain\PassengerExtras;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\Passenger\Domain\PassengerPhone;
use App\Modules\Passenger\Domain\PassengerPhoneCode;
use App\Modules\Passenger\Domain\PassengerReportable;
use App\Modules\Passenger\Domain\PassengerRestriction;
use App\Modules\Passenger\Domain\PassengerStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeRate\Domain\IdTypeRate;
use App\Modules\UserCountry\Domain\IdUserCountry;
use DateTime;

final class PassengerInserterQueryHandler implements QueryHandler
{
    public function __construct(private PassengerInserter $inserter)
    {
    }

    public function __invoke(PassengerInserterQuery $query): PassengerInserterResponse
    {
        $model = new Passenger(
            new PassengerName($query->name()),
            new PassengerLastName($query->lastName()),
            new PassengerEmail($query->email()),
            new PassengerPhoneCode($query->phoneCode()),
            new PassengerPhone($query->phone()),
            new PassengerGender($query->gender()),
            new PassengerDOB(new DateTime($query->dob())),
            new PassengerNoDocument($query->noDocument()),
            new PassengerRestriction($query->restriction()),
            new PassengerExtras($query->extras()),
            new PassengerReportable($query->reportable()),
            new PassengerStatus($query->status()),
            new IdBooking($query->idBooking()),
            new IdTypeDocument($query->idTypeDocument()),
            new IdTypeRate($query->idTypeRate()),
            new IdUserCountry($query->idUserCountry()),
        );
        return $this->inserter->__invoke($model);
    }
}
